-- load all otui files, order doesn't matter
local configName = modules.game_bot.contentsPanel.config:getCurrentOption().text

local configFiles = g_resources.listDirectoryFiles("/bot/" .. configName .. "/vBot", true, false)
for i, file in ipairs(configFiles) do
  local ext = file:split(".")
  if ext[#ext]:lower() == "ui" or ext[#ext]:lower() == "otui" then
    g_ui.importStyle(file)
  end
end

local function loadScript(name)
  return dofile("/vBot/" .. name .. ".lua")
end

-- here you can set manually order of scripts
-- libraries should be loaded first
local luaFiles = {
  "main",
  "items",
  "vlib",
  "configs", -- do not change this and above
  "extras",
  "playerlist",
  "Conditions",
  "Equipper",
  "HealBot",
  "new_healer",
  "AttackBot", -- last of major modules
  "Dropper",
  "Containers",
  "quiver_manager",
  "quiver_label",
  "tools",
  "cast_food",
  "eat_food",
  "equip",
  "spy_level",
  "npc_talk",
  "xeno_menu"
}

for i, file in ipairs(luaFiles) do
  loadScript(file)
end

-- Load TargetBot
setDefaultTab("Target")
TargetBot = {} -- global namespace
importStyle("/targetbot/looting.otui")
importStyle("/targetbot/target.otui")
importStyle("/targetbot/creature_editor.otui")
dofile("/targetbot/creature.lua")
dofile("/targetbot/creature_attack.lua")
dofile("/targetbot/creature_editor.lua")
dofile("/targetbot/creature_priority.lua")
dofile("/targetbot/looting.lua")
dofile("/targetbot/walking.lua")
-- main targetbot file, must be last
dofile("/targetbot/target.lua")

setDefaultTab("Main")
UI.Separator()
UI.Label("Private Scripts:")
UI.Separator()
