local dest
local maxDist
local params

TargetBot.walkTo = function(_dest, _maxDist, _params)
  dest = _dest
  maxDist = _maxDist
  params = _params
end

-- called every 50ms if targeting or looting is active (increased frequency)
TargetBot.walk = function()
  if not dest then return end
  if player:isWalking() then return end
  local pos = player:getPosition()
  if pos.z ~= dest.z then return end
  local dist = math.max(math.abs(pos.x-dest.x), math.abs(pos.y-dest.y))
  if params.precision and params.precision >= dist then return end
  if params.marginMin and params.marginMax then
    if dist >= params.marginMin and dist <= params.marginMax then 
      return
    end
  end
  
  -- Use more aggressive pathfinding options for better responsiveness
  local pathOptions = {
    ignoreNonPathable = true,
    ignoreCreatures = true,
    ignoreCost = true,
    ignoreLastCreature = true
  }
  
  -- Add margin parameters if they exist
  if params.marginMin and params.marginMax then
    pathOptions.marginMin = params.marginMin
    pathOptions.marginMax = params.marginMax
  end
  
  -- Add maxDistanceFrom if it exists (for anchor functionality)
  if params.maxDistanceFrom then
    pathOptions.maxDistanceFrom = params.maxDistanceFrom
  end
  
  local path = getPath(pos, dest, maxDist, pathOptions)
  if path then
    walk(path[1])
  end
end
